# coding: utf-8
import yenv

from django.conf.urls import patterns, include, url
from django.contrib import admin
from django.conf import settings

urlpatterns = patterns('',
    url(r'^auth/', include('django_yauth.urls')),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/feedback/', include('fb.feedback.urls')),
    url(r'^api/quizz/', include('fb.quizz.urls')),
    url(r'^api/staff/', include('fb.staff.urls')),
    url(r'^api/', include('fb.common.urls')),
    url(r'^idm/', include('django_idm_api.urls', namespace='idm')),
    url(r'^idm/(?P<tree>cia)/', include('django_idm_api.urls', namespace='cia')),
    url(r'^api/maintenance/', include('cia_stuff.common.urls')),
)


# Временное решение, чтобы подебажить cia в тестинге
# без валидации клиентского сертификата
if yenv.type != 'production':
    urlpatterns += patterns('',
        url(r'^(?P<tree>cia)/idm/', include('django_idm_api.urls', namespace='cia-noauth')),
    )


if settings.DEBUG:
    import debug_toolbar
    urlpatterns += patterns('',
        url(r'^__debug__/', include(debug_toolbar.urls)),
        url(r'^docs/', include('rest_framework_swagger.urls')),
    )
