FROM registry.yandex.net/tools/raw-ubuntu:18.04
ARG MODE=release
ENV IS_ARCADIA=1

EXPOSE 80

CMD ["/femida-main", "--ini=/uwsgi.ini"]

# Корневой сертификат
ADD https://crls.yandex.net/allCAs.pem /etc/yandex/femida/certs/allCAs.pem
RUN chown www-data:www-data /etc/yandex/femida/certs/allCAs.pem

# deb зависимости
COPY deps/debian-build.txt /
RUN apt-get update -qq \
    && cat debian-build.txt | xargs apt-get install -y \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/*

COPY uwsgi.ini /

COPY /femida-main/src/wsgi/femida.wsgi /femida-main

COPY /django-entrypoint.sh /usr/local/bin/femida
COPY /celery-entrypoint.sh /usr/local/bin/femida-celery
RUN chmod +x /usr/local/bin/femida
RUN chmod +x /usr/local/bin/femida-celery

# Статика
RUN femida collectstatic --noinput

# Папка для celery
RUN mkdir /celery
RUN chown www-data:www-data /celery

# Папка для tirole
RUN mkdir /tirole
RUN chown www-data:www-data /tirole
