from functools import wraps
from intranet.femida.src.actionlog.models import actionlog


def action_logged(action_name):
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            # Если декорируем метод вьюхи, возьмем initiator из self.request.user
            if args and hasattr(args[0], 'request'):
                initiator = args[0].request.user
            else:
                initiator = None
            with actionlog.init(action_name, initiator):
                return func(*args, **kwargs)
        return wrapper
    return decorator
