from django.db import models

from intranet.femida.src.actionlog.models import actionlog, SNAPSHOT_REASONS, LogRecord
from intranet.femida.src.actionlog.relations import MODEL_RELATIONS_MAP, GENERIC_RELATIONS_MAP


def add_related_objects(sender, instance):
    """
    TODO: Поддержать доступ к аттрибутам больше вложенности, если потребуется
    """
    if instance._meta.auto_created:
        for field in instance._meta.fields:
            if isinstance(field, models.AutoField):
                continue
            actionlog.add_related_object(
                obj_id=getattr(instance, field.attname),
                obj_str=field.related_model.__name__.lower(),
            )
    else:
        for field_name in MODEL_RELATIONS_MAP.get(sender, []):
            obj_id = getattr(instance, field_name)
            if obj_id is not None:
                actionlog.add_related_object(
                    obj_id=obj_id,
                    obj_str=instance._meta.get_field(field_name).related_model.__name__.lower(),
                )
        for field_name in GENERIC_RELATIONS_MAP.get(sender, []):
            generic_fk = instance._meta.get_field(field_name)
            obj_id = getattr(instance, generic_fk.fk_field)
            if obj_id is not None:
                actionlog.add_related_object(
                    obj_id=obj_id,
                    obj_str=getattr(instance, generic_fk.ct_field).name,
                )


def actionlog_update_callback(sender, **kwargs):
    for instance in kwargs.get('queryset', []):
        actionlog_callback(sender, instance=instance, created=False)


def actionlog_bulk_create_callback(sender, **kwargs):
    for instance in kwargs.get('queryset', []):
        actionlog_callback(sender, instance=instance, created=True)


def actionlog_callback(sender, **kwargs):
    created = kwargs.get('created')
    instance = kwargs.get('instance')

    if isinstance(instance, LogRecord):
        return

    if not actionlog.is_initialized():
        return

    # NOTE: Завязался на флаг created для определения сигнала post_delete
    # Наверное, это не хорошо. И может взорваться, когда я захочу использовать
    # этот коллбек для других сигналов без created
    reason = SNAPSHOT_REASONS.nothing
    if created:
        reason = SNAPSHOT_REASONS.addition
    elif created is False:
        reason = SNAPSHOT_REASONS.change
    elif created is None:
        reason = SNAPSHOT_REASONS.deletion

    actionlog.add_object(obj=instance, reason=reason)
    add_related_objects(sender, instance)

    if actionlog.ctx.action_name == 'undefined':
        actionlog.save()


def actionlog_m2m_changed_callback(sender, **kwargs):
    action = kwargs.get('action')
    instance = kwargs.get('instance')
    pk_set = kwargs.get('pk_set') or set()
    related_model = kwargs.get('model')

    reason = SNAPSHOT_REASONS.addition if action == 'post_add' else SNAPSHOT_REASONS.deletion

    instance_field_name = related_field_name = None
    for field in sender._meta.get_fields():
        if field.related_model is instance.__class__:
            instance_field_name = field.attname
        elif field.related_model is related_model:
            related_field_name = field.attname

    # В обработчике сигнала нет объектов скрытой модели. Их придется достать из базы
    if action in ('post_add', 'pre_remove'):
        objs = sender.objects.filter(**{
            related_field_name + '__in': pk_set,
            instance_field_name: instance.id,
        })
    elif action == 'pre_clear':
        objs = sender.objects.filter(**{
            instance_field_name: instance.id,
        })
    else:
        return

    if not actionlog.is_initialized():
        return

    for obj in objs:
        actionlog.add_object(obj=obj, reason=reason)
        add_related_objects(sender, instance)

    if actionlog.ctx.action_name == 'undefined':
        actionlog.save()
