import yenv
import pymongo
from pymongo.read_preferences import ReadPreference

from django.conf import settings


class MongoClient:

    def __init__(self):
        self._db = None

    @property
    def db(self):
        if self._db:
            return self._db

        connection_credentials = {
            'host': settings.MONGO_URL,
            'tz_aware': True,
            'connectTimeoutMS': 200,
            'serverSelectionTimeoutMS': 200,
            'read_preference': ReadPreference.PRIMARY_PREFERRED
        }
        if yenv.type == 'production':
            connection_credentials['replicaSet'] = settings.MONGO_REPLICA_SET

        client = pymongo.MongoClient(**connection_credentials)
        self._db = client[settings.MONGO_DATABASE]
        return self._db


mongo = MongoClient()


class ActionLogManager:
    """
    DEPRECATED: В монгу больше ничего не пишется.
    Но коллекцию мы пока не удаляем, на всякий случай.
    """
    COLLECTION_NAME = 'actionlog'

    @property
    def collection(self):
        return mongo.db[self.COLLECTION_NAME]

    def create(self, data):
        self.collection.insert_one(data)

    def filter(self, **params):
        query = {}

        if 'subject_id' in params:
            query.update({
                'subject.id': int(params['subject_id']),
            })

        if 'object_id' in params and 'object_type' in params:
            query.update({
                'related_objects': {
                    '$elemMatch': {
                        'id': int(params['object_id']),
                        '_type': params['object_type'],
                    }
                }
            })

        if 'action_name' in params:
            query.update({
                'action_name': params['action_name']
            })

        if 'action_time__gte' in params or 'action_time__lte' in params:
            action_time_query = {}
            if 'action_time__gte' in params:
                action_time_query['$gte'] = params['action_time__gte']
            if 'action_time__lte' in params:
                action_time_query['$lte'] = params['action_time__lte']
            query.update({'action_time': action_time_query})

        return self.collection.find(query)
