# Generated by Django 1.11.2 on 2018-08-20 19:08
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='LogRecord',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action_name', models.CharField(db_index=True, max_length=127)),
                ('action_time', models.DateTimeField(db_index=True, default=django.utils.timezone.now)),
                ('context', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('mongo_id', models.CharField(max_length=31)),
            ],
        ),
        migrations.CreateModel(
            name='Snapshot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('reason', models.IntegerField(choices=[(0, 'nothing'), (1, 'addition'), (2, 'change'), (3, 'deletion')])),
                ('data', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('obj_id', models.IntegerField()),
                ('obj_str', models.CharField(max_length=127)),
                ('log_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='snapshots', to='actionlog.LogRecord')),
                ('obj_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.ContentType')),
            ],
        ),
    ]
