from intranet.femida.src.interviews import models as interview_models
from intranet.femida.src.candidates import models as cand_models
from intranet.femida.src.problems import models as problem_models
from intranet.femida.src.communications import models as communication_models
from intranet.femida.src.vacancies import models as vacancy_models
from intranet.femida.src.professions.models import Profession
from intranet.femida.src.comments.models import Comment


MODEL_RELATIONS_MAP = {
    interview_models.Application: ('candidate_id', 'vacancy_id'),
    interview_models.Assignment: ('problem_id', 'interview_id'),
    interview_models.Interview: ('application_id', 'consideration_id', 'candidate_id'),
    cand_models.Consideration: ('candidate_id',),
    cand_models.CandidateContact: ('candidate_id',),
    cand_models.CandidateEducation: ('candidate_id',),
    cand_models.CandidateJob: ('candidate_id',),
    cand_models.CandidateAttachment: ('attachment_id', 'candidate_id'),
    cand_models.CandidateSkill: ('candidate_id', 'skill_id'),
    cand_models.CandidateSubmission: ('candidate_id',),
    cand_models.CandidateProfession: ('candidate_id', 'profession_id'),
    cand_models.CandidateCity: ('candidate_id', 'city_id'),
    cand_models.Challenge: ('candidate_id',),
    cand_models.DuplicationCase: ('first_candidate_id', 'second_candidate_id', 'submission_id'),
    problem_models.Problem: ('original_id',),
    problem_models.PresetProblem: ('preset_id', 'problem_id'),
    problem_models.Complaint: ('problem_id', 'original_problem_id'),
    vacancy_models.VacancyMembership: ('vacancy_id', 'member_id'),
    vacancy_models.VacancySkill: ('vacancy_id', 'skill_id'),
    communication_models.Message: ('candidate_id', 'application_id'),
    communication_models.MessageAttachment: ('message_id', 'attachment_id'),
    Profession: ('professional_sphere_id',),
}


GENERIC_RELATIONS_MAP = {
    Comment: ('related_object',),
}
