from rest_framework import serializers


class ObjectSerializer(serializers.ModelSerializer):

    class Meta:
        model = None
        fields = '__all__'

    def __init__(self, instance, *args, **kwargs):
        self.Meta.model = type(instance)
        super().__init__(
            instance=instance, *args, **kwargs)

    def get_default_field_names(self, declared_fields, model_info):
        """
        В отличие от базового метода здесь не включаем m2m-поля
        """
        return (
            [model_info.pk.name]
            + list(declared_fields.keys())
            + list(model_info.fields.keys())
            + [
                name
                for name, rel in model_info.forward_relations.items()
                if not rel.to_many
            ]
        )
