from intranet.femida.src.candidates.models import Candidate
from intranet.femida.src.celery_app import app
from intranet.femida.src.vacancies.models import Vacancy


@app.autoretry_task(max_retries=3)
def touch_candidates_task(candidate_ids):
    Candidate.unsafe.filter(id__in=candidate_ids).touch()


@app.autoretry_task(max_retries=3)
def touch_vacancies_task(vacancy_ids):
    Vacancy.unsafe.filter(id__in=vacancy_ids).touch()
