import pytz
import sform

from intranet.femida.src.api.core.forms import UserSuggestField


class ActionlogFilterForm(sform.SForm):

    action_name = sform.CharField()
    obj_id = sform.IntegerField()
    obj_str = sform.CharField()
    user = UserSuggestField()
    action_time__gte = sform.DateTimeField()
    action_time__lte = sform.DateTimeField()

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        assert 'user' in self.context
        self.user = self.context['user']

    def _clean_date(self, dt):
        return pytz.timezone(self.user.timezone).localize(dt.replace(tzinfo=None)) if dt else dt

    clean_action_time__gte = _clean_date
    clean_action_time__lte = _clean_date
