from rest_framework import serializers

from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.api.core.serializers import AwareSerializerMixin
from intranet.femida.src.actionlog.models import LogRecord, Snapshot


class SnapshotSerializer(serializers.ModelSerializer):

    reason = serializers.ReadOnlyField(source='get_reason_display')

    class Meta:
        model = Snapshot
        fields = '__all__'


class LogRecordSerializer(AwareSerializerMixin, serializers.ModelSerializer):

    user = UserSerializer()
    snapshots = SnapshotSerializer(many=True)

    class Meta:
        model = LogRecord
        fields = '__all__'
        select_related_map = {
            'user': ('user',),
        }
        prefetch_related_map = {
            'snapshots': ('snapshots',),
        }
