from intranet.femida.src.api.core.views import BaseFormViewMixin, BaseView, unfold_query_params
from intranet.femida.src.applications.dashboard.helpers import (
    filter_applications_by_dashboard_stage,
)
from intranet.femida.src.applications.helpers import annotate_with_comments_count
from intranet.femida.src.interviews.models import Application

from . import forms, serializers


class ApplicationDashboardListView(BaseFormViewMixin, BaseView):

    model_class = Application
    list_item_serializer_class = serializers.ApplicationDashboardListSerializer
    validator_class = forms.ApplicationDashboardListFilterForm

    def filter_queryset(self, queryset):
        filter_form = self.get_validator_object(self.get_initial_data())
        self.validate(filter_form)
        filter_params = filter_form.cleaned_data

        queryset = annotate_with_comments_count(queryset)
        queryset = queryset.filter(vacancy__in=filter_params['vacancies'])
        queryset = filter_applications_by_dashboard_stage(queryset, filter_params['stage'])
        return queryset.order_by('-modified')

    def get(self, request, *args, **kwargs):
        """
        Список претендентов для Дашборда
        """
        return self.list(request, *args, **kwargs)

    def get_initial_data(self):
        return unfold_query_params(
            query_params=self.request.query_params,
            list_fields=['vacancies'],
        )
