from django.conf.urls import url

from intranet.femida.src.api.communications import views as communication_views
from . import views
from .dashboard.views import ApplicationDashboardListView


urlpatterns = [
    url(
        r'^$',
        views.ApplicationListView.as_view(),
        name='list',
    ),
    url(
        r'^_filter_form/?$',
        views.ApplicationFilterFormView.as_view(),
        name='filter-form',
    ),
    url(
        r'^bulk_create/?$',
        views.ApplicationBulkCreateView.as_view(),
        name='bulk-create',
    ),
    url(
        r'^bulk_create/_form/?$',
        views.ApplicationBulkCreateView.as_form_view(),
        name='bulk-create-form',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.ApplicationDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^for_hiring_team/?$',
        views.ApplicationHiringListView.as_view(),
        name='hiring-team-list',
    ),
    url(
        r'^for_hiring_team/_filter_form/?$',
        views.ApplicationHiringListView.as_form_view(),
        name='hiring-team-list-filter-form',
    ),

    # Внутренная коммуникация (комментарии на претенденте)
    url(
        r'^(?P<application_id>\d+)/messages/?$',
        views.ApplicationMessageListCreateView.as_view(),
        name='message-list',
    ),
    url(
        # Аргумент application_id не используется
        r'^(?P<application_id>\d+)/messages/(?P<pk>\d+)/?$',
        communication_views.InternalMessageDetailView.as_view(),
        name='message-detail',
    ),
    url(
        r'^(?P<application_id>\d+)/messages/_form/?$',
        views.ApplicationMessageListCreateView.as_form_view(),
        name='message-create-form',
    ),
    url(
        # Аргумент application_id не используется
        r'^(?P<application_id>\d+)/messages/(?P<pk>\d+)/_form/?$',
        communication_views.InternalMessageDetailView.as_form_view(),
        name='message-update-form',
    ),

    url(
        r'^(?P<pk>\d+)/activate/?$',
        views.ApplicationActivateView.as_view(),
        name='activate',
    ),
    url(
        r'^(?P<pk>\d+)/activate/_form/?$',
        views.ApplicationActivateView.as_form_view(),
        name='activate-form',
    ),
    url(
        r'^(?P<pk>\d+)/close/?$',
        views.ApplicationCloseView.as_view(),
        name='close',
    ),
    url(
        r'^(?P<pk>\d+)/close/_form/?$',
        views.ApplicationCloseView.as_form_view(),
        name='close-form',
    ),
    url(
        r'^(?P<pk>\d+)/reopen/?$',
        views.ApplicationReopenView.as_view(),
        name='reopen',
    ),
    url(
        r'^(?P<pk>\d+)/reopen/_form/?$',
        views.ApplicationReopenView.as_form_view(),
        name='reopen-form',
    ),
    url(
        r'^(?P<pk>\d+)/change_resolution/?$',
        views.ApplicationChangeResolutionView.as_view(),
        name='change-resolution',
    ),
    url(
        r'^(?P<pk>\d+)/change_resolution/_form/?$',
        views.ApplicationChangeResolutionView.as_form_view(),
        name='change-resolution-form',
    ),
    url(
        r'^(?P<pk>\d+)/create_offer/?$',
        views.CreateOfferView.as_view(),
        name='create-offer',
    ),
    url(
        r'^(?P<pk>\d+)/accept_proposal/?$',
        views.ApplicationProposalView.as_view(action_name='accept_proposal'),
        name='accept-proposal',
    ),
    url(
        r'^(?P<pk>\d+)/accept_proposal/_form/?$',
        views.ApplicationProposalView.as_form_view(action_name='accept_proposal'),
        name='accept-proposal-form',
    ),
    url(
        r'^(?P<pk>\d+)/reject_proposal/?$',
        views.ApplicationProposalView.as_view(action_name='reject_proposal'),
        name='reject-proposal',
    ),
    url(
        r'^(?P<pk>\d+)/reject_proposal/_form/?$',
        views.ApplicationProposalView.as_form_view(action_name='reject_proposal'),
        name='reject-proposal-form',
    ),

    url(
        r'^dashboard/?$',
        ApplicationDashboardListView.as_view(),
        name='dashboard',
    ),
    url(
        r'^dashboard/_filter_form/?$',
        ApplicationDashboardListView.as_form_view(),
        name='dashboard-filter-form',
    ),
]
