import sform
from django.core.exceptions import ValidationError

from intranet.femida.src.interviews.choices import INTERVIEW_STATES
from intranet.femida.src.interviews.models import Assignment
from intranet.femida.src.api.core.forms import ProblemSuggestField


class AssignmentCreateForm(sform.SForm):

    problem = ProblemSuggestField(state=sform.REQUIRED)


class AssignmentForm(sform.SForm):

    comment = sform.CharField()
    grade = sform.ChoiceField(choices=Assignment.GRADES)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.interview = self.context.get('interview')

    def clean_grade(self, grade):
        return grade or None

    def clean(self):
        valid_interview_states = (
            INTERVIEW_STATES.assigned,
            INTERVIEW_STATES.estimated,
        )
        if self.interview and self.interview.state not in valid_interview_states:
            raise ValidationError(
                message='Задачу нельзя изменить в данном статусе секции',
                code='interview_invalid_state',
            )

        return super().clean()
