from rest_framework import permissions


class AssignmentPermission(permissions.BasePermission):

    def has_permission(self, request, view):
        if request.user.is_recruiter:
            return True

        if request.user == view.interview.interviewer:
            return True

        # Устанавливаем права на чтение
        if request.method in permissions.SAFE_METHODS:
            if view.interview.state == 'finished':
                return True

        return False
