from rest_framework import serializers

from intranet.femida.src.api.core.fields import SafeWikiFormattedField
from intranet.femida.src.api.core.serializers import AwareSerializerMixin, FemidaSerializer
from intranet.femida.src.api.problems.serializers import ProblemSerializer
from intranet.femida.src.interviews.choices import INTERVIEW_STATES
from intranet.femida.src.interviews.models import Assignment


class AssignmentSerializer(AwareSerializerMixin, FemidaSerializer):

    problem = ProblemSerializer()
    formatted_comment = SafeWikiFormattedField()
    grade_verbose = serializers.ReadOnlyField(source='get_grade_display')
    actions = serializers.SerializerMethodField()

    def get_actions(self, obj):
        return {
            'update': obj.interview.state in (
                INTERVIEW_STATES.assigned,
                INTERVIEW_STATES.estimated,
            ),
        }

    class Meta:
        model = Assignment
        fields = (
            'id',
            'problem',
            'comment',
            'formatted_comment',
            'grade',
            'grade_verbose',
            'position',
            'actions',
        )
        prefetch_related_map = {
            'problem': (
                'problem__created_by',
                'problem__categories',
                'problem__fans',
            ),
        }


class AssignmentLiteSerializer(FemidaSerializer):

    problem = ProblemSerializer(context={'fields': ('id', 'summary')})
    grade = serializers.ChoiceField(choices=Assignment.GRADES)
    grade_verbose = serializers.ReadOnlyField(source='get_grade_display')

    class Meta:
        model = Assignment
        fields = (
            'id',
            'problem',
            'grade',
            'grade_verbose',
            'position',
        )


class AssignmentFormSerializer(FemidaSerializer):

    class Meta:
        model = Assignment
        fields = (
            'comment',
            'grade',
        )
