from intranet.femida.src.api.core.serializers import FemidaSerializer
from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.attachments.models import Attachment


class AttachmentLiteSerializer(FemidaSerializer):

    class Meta:
        model = Attachment
        fields = (
            'id',
            'name',
            'created',
        )


class AttachmentSerializer(AttachmentLiteSerializer):

    uploader = UserSerializer()

    class Meta(AttachmentLiteSerializer.Meta):
        fields = AttachmentLiteSerializer.Meta.fields + (
            'uploader',
            'content_type',
            'size',
            'attached_file',
            'sha1',
        )
