import sform

from django.utils.functional import cached_property
from rest_framework import status

from intranet.femida.src.api.core.forms import CandidateSuggestField
from intranet.femida.src.api.core.views import ResponseError


class CandidateSuggestForm(sform.SForm):

    candidate = CandidateSuggestField(state=sform.REQUIRED)


class CandidateHelperFormMixin:
    """
    TODO: Это хак! Надо как-то избавиться от этого.
    Возможное решение - засунуть создание секции и претендентсва в воркфлоу кандидата,
    чтобы в урле присутствовал id кандидата.

    Получаем кандидата из query_params или data. Кандидат нужен нам до создания самой формы,
    потому от него зависит как будет выглядеть и валидироваться сама форма.
    """
    @cached_property
    def candidate(self):
        candidate_id = self.request.query_params.get('candidate')
        if not candidate_id:
            candidate_id = self.request.data.get('candidate')

        helper_form = CandidateSuggestForm(data={'candidate': candidate_id})
        if not helper_form.is_valid():
            raise ResponseError(
                data=helper_form.errors,
                status=status.HTTP_400_BAD_REQUEST,
            )
        candidate = helper_form.cleaned_data['candidate']
        self.check_object_permissions(self.request, candidate)
        return candidate
