from django.conf.urls import url
from django.urls import path

from intranet.femida.src.api.certifications import views as certification_views
from intranet.femida.src.api.communications import views as communication_views
from . import views


urlpatterns = [
    url(
        r'^$',
        views.CandidateListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_form/?$',
        views.CandidateCreateFormView.as_view(),
        name='create-form',
    ),
    path(
        'filter/',
        views.CandidateFilterView.as_view({'get': 'list'}),
        name='filter',
    ),
    path(
        'filter/_count/',
        views.CandidateFilterView.as_view({'get': 'count'}),
        name='filter-count',
    ),
    path(
        'filter/_filter_form/',
        views.CandidateFilterView.as_form_view(),
        name='filter-form',
    ),
    url(
        r'^for_recruiter/?$',
        views.CandidateRecruiterListView.as_view(),
        name='recruiter-list',
    ),
    url(
        r'^for_recruiter/_filter_form/?$',
        views.CandidateRecruiterListView.as_form_view(),
        name='recruiter-list-filter-form',
    ),
    url(
        r'^search/?$',
        views.CandidatesSearchView.as_view(),
        name='search',
    ),
    url(
        r'^search/_form/?$',
        views.CandidatesSearchFormView.as_view(),
        name='search-form',
    ),
    url(
        r'^check_for_duplicates/?$',
        views.CandidateCheckForDuplicatesView.as_view(),
        name='check-for-duplicates'
    ),
    url(
        r'^_compare/?$',
        views.CandidateCompareView.as_view(),
        name='compare',
    ),
    url(
        r'^merge/?$',
        views.CandidateMergeView.as_view(),
        name='merge',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.CandidateDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.CandidateDetailView.as_form_view(),
        name='update-form',
    ),
    url(
        r'^(?P<pk>\d+)/actual_applications/?$',
        views.CandidateApplicationListView.as_view(),
        name='actual-application-list',
    ),
    url(
        r'^(?P<pk>\d+)/send_for_approval/?$',
        views.CandidateSendForApprovalView.as_view(),
        name='send-for-approval',
    ),
    url(
        r'^(?P<pk>\d+)/send_for_approval/_form/?$',
        views.CandidateSendForApprovalView.as_form_view(),
        name='send-for-approval-form',
    ),
    url(
        r'^(?P<pk>\d+)/open/?$',
        views.CandidateOpenView.as_view(),
        name='open',
    ),
    url(
        r'^(?P<pk>\d+)/open/_form/?$',
        views.CandidateOpenView.as_form_view(),
        name='open-form',
    ),
    url(
        r'^(?P<pk>\d+)/close/?$',
        views.CandidateCloseView.as_view(),
        name='close',
    ),
    url(
        r'^(?P<pk>\d+)/close/_form/?$',
        views.CandidateCloseView.as_form_view(),
        name='close-form',
    ),
    url(
        r'^(?P<pk>\d+)/create_proposals/?$',
        views.CandidateCreateProposalsView.as_view(),
        name='create-proposals',
    ),
    url(
        r'^(?P<pk>\d+)/create_proposals/_form/?$',
        views.CandidateCreateProposalsFormView.as_form_view(),
        name='create-proposals-form',
    ),
    url(
        r'^(?P<pk>\d+)/close_irrelevant_applications/?$',
        views.CandidateCloseIrrelevantApplicationsView.as_view(),
        name='close-irrelevant-applications',
    ),
    url(
        r'^(?P<pk>\d+)/close_irrelevant_applications/_form/?$',
        views.CandidateCloseIrrelevantApplicationsView.as_form_view(),
        name='close-irrelevant-applications-form',
    ),
    url(
        r'^(?P<pk>\d+)/verifications/?$',
        views.CandidateCreateVerificationView.as_view(),
        name='verification-create',
    ),
    url(
        r'^(?P<pk>\d+)/verifications/_form/?$',
        views.CandidateCreateVerificationView.as_form_view(),
        name='verification-create-form',
    ),

    url(
        r'^(?P<pk>\d+)/interview_round_create/?$',
        views.InterviewRoundCreateView.as_view(),
        name='interview-round-create',
    ),
    url(
        r'^(?P<pk>\d+)/interview_round_create/_form/?$',
        views.InterviewRoundCreateView.as_form_view(),
        name='interview-round-create-form',
    ),

    # Заметки
    url(
        r'^(?P<candidate_id>\d+)/notes/?$',
        communication_views.NoteListCreateView.as_view(),
        name='note-list',
    ),
    url(
        r'^(?P<candidate_id>\d+)/notes/(?P<pk>\d+)/?$',
        communication_views.NoteDetailView.as_view(),
        name='note-detail',
    ),
    url(
        r'^(?P<candidate_id>\d+)/notes/_form/?$',
        communication_views.NoteListCreateView.as_form_view(),
        name='note-create-form',
    ),
    url(
        r'^(?P<candidate_id>\d+)/notes/(?P<pk>\d+)/_form/?$',
        communication_views.NoteDetailView.as_form_view(),
        name='note-update-form',
    ),

    # Сертификаты
    url(
        r'^(?P<pk>\d+)/certifications/?$',
        certification_views.CandidateCertificationCreateView.as_view(),
        name='certification-create',
    ),
    url(
        r'^(?P<pk>\d+)/certifications/_form/?$',
        certification_views.CandidateCertificationCreateView.as_form_view(),
        name='certification-create-form',
    ),

    # Финансы
    url(
        r'^(?P<pk>\d+)/costs?$',
        views.CandidateCostsView.as_view(),
        name='costs',
    ),
    url(
        r'^(?P<pk>\d+)/costs/_form?$',
        views.CandidateCostsView.as_form_view(),
        name='costs-form',
    ),
]
