from operator import attrgetter, itemgetter

import waffle
from intranet.femida.src.candidates.choices import RKN_CONTACT_TYPES, CONTACT_TYPES


def get_unique_contacts(obj):
    unique_set = set()
    data = []
    for contact in obj.contacts.all():
        if not contact.is_active:
            continue
        account_id = contact.normalized_account_id or contact.account_id
        if (contact.type, account_id) not in unique_set:
            unique_set.add((contact.type, account_id))
            data.append({
                'id': contact.id,
                'type': contact.type,
                'account_id': account_id,
                'is_main': contact.is_main,
                'is_active': contact.is_active,
                'is_normalized': contact.is_normalized,
            })
    if waffle.switch_is_active('is_rkn'):
        data = [i for i in data if i['type'] in RKN_CONTACT_TYPES]
    return data


def get_skype_accounts(candidate):
    contacts = sorted(
        (c for c in get_unique_contacts(candidate) if c['type'] == CONTACT_TYPES.skype),
        key=itemgetter('is_main'),
        reverse=True,
    )
    return ', '.join(c['account_id'] for c in contacts)


def get_sorted_serialized_attachments(attachments):
    sorted_attachments = sorted(
        attachments,
        key=attrgetter('created'),
        reverse=True,
    )
    return [
        {
            'id': attachment.id,
            'name': attachment.name,
            'created': attachment.created,
        }
        for attachment in sorted_attachments
    ]


def get_unique_serialized_attachments(obj):
    attachments = {}
    for attachment in obj.attachments.all():
        sha1 = attachment.sha1
        is_suitable_attachment = (
            sha1 not in attachments
            or attachments[sha1].created < attachment.created
        )
        if is_suitable_attachment:
            attachments[sha1] = attachment

    return get_sorted_serialized_attachments(attachments.values())
