from rest_framework import serializers

from intranet.femida.src.api.core.serializers import AwareSerializerMixin, FemidaSerializer
from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.problems.models import Category


class CategorySerializer(AwareSerializerMixin, FemidaSerializer):

    problems_count = serializers.IntegerField()
    active_complaints_count = serializers.IntegerField()
    is_user_subscribed = serializers.SerializerMethodField()
    subscribers = UserSerializer(many=True)

    def get_is_user_subscribed(self, obj):
        user_category_ids = self.root.context.get('user_category_ids', set())
        return obj.id in user_category_ids

    class Meta:
        model = Category
        fields = (
            'id',
            'name',
            'problems_count',
            'active_complaints_count',
            'is_user_subscribed',
            'subscribers',
        )
        prefetch_related_map = {
            'subscribers': ('subscribers',),
        }
