import sform

from intranet.femida.src.api.core.forms import ConsiderationChoiceField, EMPTY_LABEL
from intranet.femida.src.candidates.models import Consideration


class CandidateCertificationCreateForm(sform.SForm):

    receiver = sform.EmailField(
        max_length=255,
        state=sform.REQUIRED,
    )
    consideration = ConsiderationChoiceField(
        queryset=Consideration.unsafe.none(),
        state=sform.REQUIRED,
        empty_label=EMPTY_LABEL,
    )

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        considerations = self.context.get('considerations')
        assert considerations is not None
        self.fields['consideration'].queryset = considerations
