from django.urls import path

from . import views


urlpatterns = [
    path(
        '<uuid:private_uuid>/',
        views.CertificationDetailView.as_view(),
        name='detail',
    ),
    path(
        '<uuid:private_uuid>/publish/',
        views.CertificationPublishView.as_view(),
        name='publish',
    ),
    path(
        '<uuid:private_uuid>/unpublish/',
        views.CertificationUnpublishView.as_view(),
        name='unpublish',
    ),
    path(
        'public/<uuid:public_uuid>/',
        views.CertificationPublicView.as_view(),
        name='public',
    ),
]
