from intranet.femida.src.api.certifications import forms, serializers
from intranet.femida.src.api.core.permissions import StrictServicePermission
from intranet.femida.src.api.core.views import BaseView, InstanceFormViewMixin, WorkflowView
from intranet.femida.src.candidates.models import Candidate
from intranet.femida.src.candidates.workflow import CandidateWorkflow
from intranet.femida.src.certifications.helpers import get_considerations_for_certification
from intranet.femida.src.certifications.models import Certification
from intranet.femida.src.certifications.workflow import CertificationWorkflow
from intranet.femida.src.core.shortcuts import get_object_or_40x


class CertificationViewMixin:

    model_class = Certification
    detail_serializer_class = serializers.CertificationSerializer
    permission_classes = (
        StrictServicePermission('permissions.can_access_certification_data'),
    )

    def get_object(self):
        return get_object_or_40x(self.model_class, private_uuid=self.kwargs['private_uuid'])


class CertificationWorkflowView(CertificationViewMixin, WorkflowView):

    workflow_class = CertificationWorkflow

    @property
    def actionlog_name(self):
        return f'certification_{self.action_name}'


class CertificationDetailView(CertificationViewMixin, BaseView):

    def get(self, request, *args, **kwargs):
        return self.retrieve(request, *args, **kwargs)


class CertificationPublishView(CertificationWorkflowView):

    action_name = 'publish'


class CertificationUnpublishView(CertificationWorkflowView):

    action_name = 'unpublish'


class CandidateCertificationCreateView(InstanceFormViewMixin, WorkflowView):

    action_name = 'certification_create'
    actionlog_name = 'candidate_certification_create'

    model_class = Candidate
    workflow_class = CandidateWorkflow

    validator_class = forms.CandidateCertificationCreateForm
    form_serializer_class = serializers.CandidateCertificationCreateFormSerializer
    detail_serializer_class = serializers.CandidateCertificationDetailSerializer

    def get_validator_context(self):
        return {
            'considerations': get_considerations_for_certification(self.get_object()),
        }


class CertificationPublicView(CertificationViewMixin, BaseView):

    detail_serializer_class = serializers.CertificationPublicSerializer

    def get_object(self):
        return get_object_or_40x(
            self.model_class,
            public_uuid=self.kwargs['public_uuid'],
        )

    def get(self, request, *args, **kwargs):
        return self.retrieve(request, *args, **kwargs)
