from intranet.femida.src.api.comments.views import CommentListCreateBaseView
from intranet.femida.src.api.core.views import WorkflowView, InstanceFormViewMixin
from intranet.femida.src.candidates.challenges.workflow import ChallengeWorkflow
from intranet.femida.src.candidates.controllers import get_candidates_extended_statuses
from intranet.femida.src.candidates.models import Challenge
from . import serializers, forms


class ChallengeCommentListCreateView(CommentListCreateBaseView):

    related_model_class = Challenge
    related_workflow_class = ChallengeWorkflow
    action_name = 'comment_add'
    actionlog_name = 'challenge_comment_add'


class ChallengeWorkflowView(WorkflowView):

    model_class = Challenge
    workflow_class = ChallengeWorkflow
    detail_serializer_class = serializers.ChallengeSerializer

    def get_detail_serializer_context(self):
        candidate_id = self.get_object().candidate_id
        return {
            'extended_statuses': get_candidates_extended_statuses([candidate_id]),
        }

    @property
    def actionlog_name(self):
        return 'challenge_%s' % self.action_name


class ChallengeEstimateView(InstanceFormViewMixin, ChallengeWorkflowView):

    action_name = 'estimate'
    validator_class = forms.ChallengeEstimateForm
    form_serializer_class = serializers.ChallengeEstimateFormSerializer


class ChallengeCancelView(ChallengeWorkflowView):

    action_name = 'cancel'
    validator_class = forms.ChallengeCancelForm
