from intranet.femida.src.api.core.serializers import (
    FemidaSerializer,
    AwareSerializerMixin,
    WorkflowActionsField,
)
from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.comments.models import Comment
from intranet.femida.src.comments.workflow import CommentWorkflow


class CommentSerializer(AwareSerializerMixin, FemidaSerializer):

    created_by = UserSerializer()
    actions = WorkflowActionsField(workflow_class=CommentWorkflow)

    class Meta:
        model = Comment
        fields = (
            'id',
            'text',
            'formatted_text',
            'created_by',
            'is_edited',
            'created',
            'modified',
            'actions',
        )

        select_related_map = {
            'created_by': ('created_by',),
        }
