from django.conf.urls import url

from . import views


urlpatterns = [
    # Внешняя коммуникация
    # TODO: FEMIDA-5739: удалить устаревший url после релиза фронта
    url(
        r'^message_templates/?$',
        views.MessageTemplatesView.as_view(),
        name='templates-list',
    ),
    url(
        r'^candidates/(?P<candidate_id>\d+)/message_templates/?$',
        views.MessageTemplatesView.as_view(),
        name='candidate-message-template-list',
    ),
    url(
        r'^candidates/(?P<candidate_id>\d+)/messages/?$',
        views.CandidateMessageListCreateView.as_view(),
        name='candidate-message-list',
    ),
    url(
        r'^candidates/(?P<candidate_id>\d+)/messages/_form/?$',
        views.CandidateMessageListCreateView.as_form_view(),
        name='candidate-message-create-form',
    ),
    url(
        r'^candidates/(?P<candidate_id>\d+)/messages/(?P<pk>\d+)/?$',
        views.ExternalMessageDetailView.as_view(),
        name='candidate-message-detail',
    ),
    url(
        r'^candidates/(?P<candidate_id>\d+)/messages/(?P<pk>\d+)/_form/?$',
        views.ExternalMessageDetailView.as_form_view(),
        name='candidate-message-update-form',
    ),
]
