from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.ComplaintListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_form/?$',
        views.ComplaintListCreateView.as_form_view(),
        name='create-form',
    ),
    url(
        r'^_filter_form/?$',
        views.ComplaintListFilterFormView.as_view(),
        name='filter-form',
    ),
    url(
        r'^(?P<pk>\d+)/reject/?$',
        views.ComplaintRejectView.as_view(),
        name='reject',
    ),
    url(
        r'^(?P<pk>\d+)/resolve/?$',
        views.ComplaintResolveView.as_view(),
        name='resolve',
    ),
    url(
        r'^(?P<pk>\d+)/comments/?$',
        views.ComplaintCommentListCreateView.as_view(),
        name='comments',
    ),
]
