import sform

from constance import config

from intranet.femida.src.api.core.fetchers import query_params_data_getter
from intranet.femida.src.api.core.forms import (
    EMPTY_LABEL,
    UserMultipleSuggestField,
    ProfessionMultipleChoiceField,
    BaseMetaForm,
    VacancyMultipleSuggestField,
)
from intranet.femida.src.candidates.choices import (
    CONSIDERATION_DASHBOARD_STAGES,
    CANDIDATE_RESPONSIBLE_ROLES,
)
from intranet.femida.src.candidates.consideration_issues.base import IssueTypesRegistry


class ConsiderationDashboardListFilterForm(BaseMetaForm):

    default_getter = query_params_data_getter

    stage = sform.ChoiceField(choices=CONSIDERATION_DASHBOARD_STAGES, state=sform.REQUIRED)
    role = sform.ChoiceField(
        choices=CANDIDATE_RESPONSIBLE_ROLES,
        default=CANDIDATE_RESPONSIBLE_ROLES.main_recruiter,
        empty_label=EMPTY_LABEL,
    )
    users = UserMultipleSuggestField(state=sform.REQUIRED)
    professions = ProfessionMultipleChoiceField()
    finished__gte = sform.DateTimeField()
    finished__lte = sform.DateTimeField()
    only_with_issues = sform.BooleanField()
    issue_types = sform.MultipleChoiceField(
        choices=[(t, t) for t in IssueTypesRegistry.get_issue_types()],
    )
    vacancies = VacancyMultipleSuggestField()

    def get_field_state(self, name):
        if name == 'issue_types' and not self.cleaned_data.get('only_with_issues'):
            return sform.READONLY
        return super().get_field_state(name)

    def meta_as_dict(self):
        return {'info_text': config.CONSIDERATION_DASHBOARD_INFO_TEXT}
