import yenv
from rest_framework.authentication import SessionAuthentication


class FemidaAuthentication(SessionAuthentication):
    """
    DRF-аутентификация Фемиды.
    Основана на сессионной аутентификации,
    отличается от неё тем, что при походах в Фемиду через oauth или tvm,
    CSRF-защита отключается. В CSRF-защите нет необходимости, когда запрос
    отправляется не из браузера.
    """
    def enforce_csrf(self, request):
        # Не проверяем CSRF в dev-окружениях
        if yenv.type == 'development':
            return

        mechanism = request.yauser.authenticated_by.mechanism_name

        # Не проверяем CSRF при авторизации по oauth и tvm
        if mechanism in {'oauth', 'tvm'}:
            return

        return super().enforce_csrf(request)
