from rest_framework import serializers

from intranet.femida.src.api.core.serializers import IdNameSerializer
from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.candidates.models import Consideration
from intranet.femida.src.core.models import City
from intranet.femida.src.interviews.models import Interview
from intranet.femida.src.jobs.public_professions.models import PublicProfession
from intranet.femida.src.professions.models import Profession
from intranet.femida.src.services.models import PublicService
from intranet.femida.src.skills.models import Skill


class CityAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.ReadOnlyField(source='name')
    name = serializers.ReadOnlyField()
    country = IdNameSerializer()
    priority = serializers.ReadOnlyField(source='external_publications_count')

    class Meta:
        model = City
        fields = (
            'label',
            'name',
            'country',
            'priority',
        )


class InterviewAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.CharField(source='section')
    interviewer = UserSerializer()

    class Meta:
        model = Interview
        fields = (
            'label',
            'type',
            'state',
            'section',
            'interviewer',
            'grade',
            'resolution',
        )


class ProfessionAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.ReadOnlyField(source='localized_name')
    name = serializers.ReadOnlyField(source='localized_name')
    professional_sphere = IdNameSerializer(name_source='localized_name')
    priority = serializers.ReadOnlyField(source='external_publications_count')

    class Meta:
        model = Profession
        fields = (
            'label',
            'name',
            'professional_sphere',
            'priority',
        )


class PublicProfessionAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.ReadOnlyField(source='name')
    name = serializers.ReadOnlyField()
    professional_sphere = IdNameSerializer(source='public_professional_sphere')
    priority = serializers.ReadOnlyField(source='external_publications_count')

    class Meta:
        model = PublicProfession
        fields = (
            'label',
            'name',
            'professional_sphere',
            'priority',
        )


class PublicServiceAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.ReadOnlyField(source='name')
    name = serializers.ReadOnlyField()
    description = serializers.ReadOnlyField()
    priority = serializers.ReadOnlyField(source='external_publications_count')

    class Meta:
        model = PublicService
        fields = (
            'label',
            'name',
            'description',
            'icon',
            'priority',
        )


class SkillAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.ReadOnlyField(source='name')
    priority = serializers.ReadOnlyField(source='external_publications_count')

    class Meta:
        model = Skill
        fields = (
            'label',
            'priority',
        )


class ConsiderationAsChoiceSerializer(serializers.ModelSerializer):

    label = serializers.SerializerMethodField()

    def get_label(self, obj):
        return str(obj)

    class Meta:
        model = Consideration
        fields = (
            'label',
            'state',
            'extended_status',
            'started',
            'finished',
        )
