from rest_framework import permissions

from intranet.femida.src.permissions.helpers import has_service_permission


ACCESS_DENIED_MSG = 'У вас недостаточно прав для просмотра этой страницы.'
APPLICATION_NOT_FINISHED_MSG = (
    'У вас недостаточно прав для просмотра этой страницы. '
    'Она станет видна, когда собеседование будет завершено.'
)


class BaseGlobalPermission(permissions.BasePermission):

    def __init__(self, *perms):
        self.permissions = perms

    def __call__(self):
        return self


class IsRecruiter(permissions.BasePermission):

    def has_permission(self, request, view):
        return request.user.is_recruiter


class IsRecruiterOrAssessor(permissions.BasePermission):

    def has_permission(self, request, view):
        return request.user.is_recruiter or request.user.is_recruiter_assessor


class IsSuperuser(permissions.BasePermission):

    def has_permission(self, request, view):
        return request.user.is_superuser


class UserPermission(BaseGlobalPermission):

    def has_permission(self, request, view):
        return any(request.user.has_perm(perm) for perm in self.permissions)


class ServicePermission(BaseGlobalPermission):
    """
    Проверяет права у tvm приложений.
    Если пришли не по tvm, ничего не проверяет
    """
    strict = False

    def has_permission(self, request, view):
        yauser = request.yauser
        if not yauser.is_authenticated() or yauser.authenticated_by.mechanism_name != 'tvm':
            return not self.strict
        return any(has_service_permission(yauser, perm) for perm in self.permissions)


class StrictServicePermission(ServicePermission):
    """
    Проверяет права у tvm приложений.
    Если пришли не по tvm, запрещает доступ
    """
    strict = True
