from io import BytesIO

from xlwt.Workbook import Workbook

from rest_framework_csv.renderers import CSVRenderer


class XLSRenderer(CSVRenderer):
    """
    Renderer which serializes to XLS
    """
    media_type = 'application/vnd.ms-excel'
    format = 'xls'

    def render(self, data, media_type=None, renderer_context=None, writer_opts=None):
        renderer_context = renderer_context or {}

        wb = Workbook(encoding='utf8')
        sheet = wb.add_sheet('femida')
        buffer = BytesIO()

        if data is None:
            wb.save(buffer)
            return buffer.getvalue()

        if not isinstance(data, list):
            data = [data]

        header = renderer_context.get('header', self.header)
        labels = renderer_context.get('labels', self.labels)
        table = self.tablize(data, header=header, labels=labels)

        for r, row in enumerate(table):
            for c, elem in enumerate(row):
                sheet.write(r, c, elem)

        wb.save(buffer)
        return buffer.getvalue()
