from rest_framework import serializers

from intranet.femida.src.api.users.serializers import UserSerializer
from intranet.femida.src.api.candidates.serializers import CandidateLiteSerializer
from intranet.femida.src.candidates import models
from intranet.femida.src.candidates.choices import DUPLICATION_CASE_STATUSES
from intranet.femida.src.candidates.workflow import DuplicationCaseWorkflow


class DuplicationCaseSerializer(serializers.ModelSerializer):

    first_candidate = CandidateLiteSerializer()
    second_candidate = CandidateLiteSerializer()
    merged_to = CandidateLiteSerializer()
    managed_by = UserSerializer()
    similarity_info = serializers.ReadOnlyField(source='similarity_info.to_dict')
    actions = serializers.SerializerMethodField()

    def get_actions(self, obj):
        actions = DuplicationCaseWorkflow(instance=obj, user=None).get_actions_visibility()
        actions['merge'] = obj.status == DUPLICATION_CASE_STATUSES.new
        return actions

    class Meta:
        model = models.DuplicationCase
        fields = '__all__'
