from django.conf.urls import url
from drf_yasg import openapi
from drf_yasg.views import get_schema_view

from .offers import views as offer_views
from .preprofiles import views as preprofile_views

urlpatterns = []

urlpatterns += [
    url(r'^swagger/$', get_schema_view(
        openapi.Info(title='Femida Api', default_version='v1'),
        public=True,
        urlconf='intranet.femida.src.api.external_urls'
    ).with_ui())
]

urlpatterns += [
    # OFFER
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/accept/?$',
        offer_views.OfferAcceptView.as_view(),
        name='offers-accept',
    ),
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/accept/_form/?$',
        offer_views.OfferAcceptView.as_form_view(),
        name='offers-accept-form',
    ),
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/attach_eds_phone/?$',
        offer_views.OfferAttachEdsPhoneView.as_view(),
        name='offers-attach-eds-phone',
    ),
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/verify_eds_phone/?$',
        offer_views.OfferVerifyEdsPhoneView.as_view(),
        name='offers-verify-eds-phone',
    ),
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/attachments/?$',
        offer_views.OfferAttachmentUploadView.as_view(),
        name='offers-attachment-upload',
    ),
    url(
        r'^offers/(?P<uid>[0-9a-f]{32})/check_login/?$',
        offer_views.OfferCheckLoginExternalView.as_view(),
        name='offers-check-login',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/accept/?$',
        preprofile_views.PreprofileAcceptView.as_view(),
        name='preprofiles-accept',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/accept/_form/?$',
        preprofile_views.PreprofileAcceptView.as_form_view(),
        name='preprofiles-accept-form',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/attach_eds_phone/?$',
        preprofile_views.PreprofileAttachEdsPhoneView.as_view(),
        name='preprofiles-attach-eds-phone',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/verify_eds_phone/?$',
        preprofile_views.PreprofileVerifyEdsPhoneView.as_view(),
        name='preprofiles-verify-eds-phone',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/attachments/?$',
        preprofile_views.PreprofileAttachmentUploadView.as_view(),
        name='preprofiles-attachment-upload',
    ),
    url(
        r'^preprofiles/(?P<uid>[0-9a-f]{32})/check_login/?$',
        preprofile_views.PreprofileCheckLoginExternalView.as_view(),
        name='preprofiles-check-login',
    ),
]
