from rest_framework.response import Response

from intranet.femida.src.actionlog.decorators import action_logged
from intranet.femida.src.api.core.views import BaseView
from intranet.femida.src.forms_constructor.controllers import (
    handle_submission_form_answer,
    handle_verification_form_answer,
    VerificationResult,
)
from intranet.femida.src.interviews.tasks import create_aa_entry_issue_task

from . import forms, permissions


class FormsConstructorBaseView(BaseView):

    permission_classes = [permissions.FormsConstructorPermission]


class FormsConstructorSubmissionView(FormsConstructorBaseView):

    @action_logged('submission_create')
    def post(self, request, *args, **kwargs):
        """
        Создание отклика через Конструктор форм
        """
        handle_submission_form_answer(request.data)
        return Response()


class FormsConstructorAAEntryView(FormsConstructorBaseView):

    validator_class = forms.FormsConstructorAAEntryForm

    @action_logged('aa_entry_create')
    def post(self, request, *args, **kwargs):
        """
        Ручка для КФ. Заявка на вступление в ряды AA.
        """
        data = request.data.get('params', {})
        validator = self.get_validator_object(data)
        self.validate(validator)
        create_aa_entry_issue_task.delay(
            applicant_id=validator.cleaned_data['applicant'].id,
            answers=validator.cleaned_data['answers'],
        )
        return Response()


class FormsConstructorVerificationView(FormsConstructorBaseView):

    @action_logged('candidate_verification_submission')
    def post(self, request, *args, **kwargs):
        """
        Получаем заполненную кандидатом анкету КИ - конфликта интересов
        """
        handle_verification_form_answer(request.data)
        return Response()


class FormsConstructorVerificationSuccessView(FormsConstructorBaseView):

    @action_logged('candidate_verification_success')
    def post(self, request, *args, **kwargs):
        """
        Ручка для интеграции с КФ в форме результатов проверки КИ.
        Вызывается, если вендор поставил ОК во всех полях.
        """
        VerificationResult(request.data, ok=True).update_verification()
        return Response()


class FormsConstructorVerificationEssCheckView(FormsConstructorBaseView):

    @action_logged('candidate_verification_ess_check')
    def post(self, request, *args, **kwargs):
        """
        Ручка для интеграции с КФ в форме результатов проверки КИ.
        Вызывается, если вендор поставил не ОК в хотя бы одном из полей.
        """
        VerificationResult(request.data, ok=False).update_verification()
        return Response()
