from constance import config
from rest_framework import status
from rest_framework.response import Response

from intranet.femida.src.actionlog.decorators import action_logged
from intranet.femida.src.api.core.permissions import UserPermission
from intranet.femida.src.api.core.views import BaseView


class FrontendVersionView(BaseView):

    permission_classes = [
        UserPermission('permissions.can_use_frontend_version_view'),
    ]

    @action_logged('frontend_change_version')
    def post(self, request, *args, **kwargs):
        version = request.data.get('version')
        if not version:
            return Response(status=status.HTTP_400_BAD_REQUEST)

        # выставление атрибута FRONTEND_VERSION отправляет сигнал config_updated
        # при получении сигнала обновляется manifest.json
        config.FRONTEND_VERSION = version
        return Response()
