from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        '^authorize/?$',
        views.AuthorizeView.as_view(),
        name='authorize',
    ),
    url(
        '^token_refresh/?$',
        views.TokenRefreshView.as_view(),
        name='token-refresh',
    ),
    url(
        r'^resumes/(?P<resume_id>\w+)\.(?P<file_type>\w{3})$',
        views.ResumeFileView.as_view(),
        name='resume-file',
    ),
    url(
        r'^resume_upload/?$',
        views.ResumeUploadView.as_view(),
        name='resume-upload',
    ),
]
