from django.urls import path

from . import views


urlpatterns = [
    path(
        '',
        views.HireOrderListCreateView.as_view(),
        name='list',
    ),
    path(
        '<uuid:uuid>/',
        views.HireOrderDetailView.as_view(),
        name='detail',
    ),
    path(
        '<uuid:uuid>/history/',
        views.HireOrderHistoryListView.as_view(),
        name='history',
    ),
    path(
        '<uuid:uuid>/cancel/',
        views.HireOrderCancelView.as_view(),
        name='cancel',
    ),
]
