from django.utils.decorators import method_decorator

from intranet.femida.src.api.core.errors import locked_is_forbidden
from intranet.femida.src.api.core.views import WorkflowView
from intranet.femida.src.interviews.models import InterviewRound
from intranet.femida.src.interviews.workflow import InterviewRoundWorkflow


class InterviewRoundWorkflowView(WorkflowView):

    model_class = InterviewRound
    workflow_class = InterviewRoundWorkflow

    @property
    def actionlog_name(self):
        return f'interview_round_{self.action_name}'


@method_decorator(locked_is_forbidden, name='dispatch')
class InterviewRoundCancelView(InterviewRoundWorkflowView):

    action_name = 'cancel'

    def get_queryset(self):
        return (
            super().get_queryset()
            .select_for_update()
        )
