from rest_framework import permissions
from rest_framework.exceptions import PermissionDenied

from intranet.femida.src.api.core.permissions import (
    ACCESS_DENIED_MSG,
    APPLICATION_NOT_FINISHED_MSG,
)
from intranet.femida.src.interviews.helpers import InterviewVisibilityHelper
from intranet.femida.src.offers.choices import OFFER_STATUSES


class InterviewListCreatePermission(permissions.BasePermission):

    def has_permission(self, request, view):
        return (
            request.method in permissions.SAFE_METHODS
            or (
                request.user.is_recruiter
                or request.user.is_recruiter_assessor
            )
            and not view.candidate.offers.filter(status__in=(
                OFFER_STATUSES.sent,
                OFFER_STATUSES.accepted,
            )).exists()
        )


class InterviewPermission(permissions.BasePermission):

    def has_object_permission(self, request, view, obj):
        visibility_helper = InterviewVisibilityHelper(request.user, obj.consideration)

        if visibility_helper.is_editable(obj):
            return True

        if request.method in permissions.SAFE_METHODS:
            if request.user.is_analyst or visibility_helper.is_visible(obj):
                return True
            else:
                raise PermissionDenied(APPLICATION_NOT_FINISHED_MSG)

        raise PermissionDenied(ACCESS_DENIED_MSG)


class InterviewsReportPermission(permissions.BasePermission):

    def has_permission(self, request, view):
        return request.user.is_recruiter or request.user.is_analyst
