from django.conf.urls import url
from django.urls import path

from . import views


urlpatterns = [
    url(
        r'^$',
        views.InterviewListCreateView.as_view(),
        name='list',
    ),
    url(
        r'^_form/?$',
        views.InterviewCreateFormView.as_view(),
        name='create-form',
    ),
    url(
        r'^_filter_form/?$',
        views.InterviewListFilterFormView.as_view(),
        name='filter-form',
    ),
    path(
        'achievements/',
        views.InterviewAchievementView.as_view(),
        name='achievements',
    ),
    url(
        r'^report/?$',
        views.InterviewsReportView.as_view(),
        name='report',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.InterviewDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.InterviewDetailView.as_form_view(),
        name='update-form',
    ),
    url(
        r'^(?P<pk>\d+)/rename/?$',
        views.InterviewRenameView.as_view(),
        name='rename',
    ),
    url(
        r'^(?P<pk>\d+)/rename/_form/?$',
        views.InterviewRenameView.as_form_view(),
        name='rename-form',
    ),
    url(
        r'^(?P<pk>\d+)/event/?$',
        views.InterviewEventView.as_view(),
        name='event',
    ),
    url(
        r'^(?P<pk>\d+)/finish/?$',
        views.InterviewFinishView.as_view(),
        name='finish',
    ),
    url(
        r'^(?P<pk>\d+)/cancel/?$',
        views.InterviewCancelView.as_view(),
        name='cancel',
    ),
    url(
        r'^(?P<pk>\d+)/estimate/?$',
        views.InterviewEstimateView.as_view(),
        name='estimate',
    ),
    url(
        r'^(?P<pk>\d+)/comment/?$',
        views.InterviewCommentView.as_view(),
        name='comment',
    ),
    url(
        r'^(?P<pk>\d+)/reassign/?$',
        views.InterviewReassignView.as_view(),
        name='reassign',
    ),
    url(
        r'^(?P<pk>\d+)/reassign/_form/?$',
        views.InterviewReassignView.as_form_view(),
        name='reassign-form',
    ),
    url(
        r'^(?P<pk>\d+)/reorder/?$',
        views.InterviewReorderView.as_view(),
        name='reorder',
    ),
    url(
        r'^(?P<pk>\d+)/change_resolution/?$',
        views.InterviewChangeResolutionView.as_view(),
        name='change-resolution',
    ),
    url(
        r'^(?P<pk>\d+)/change_resolution/_form/?$',
        views.InterviewChangeResolutionView.as_form_view(),
        name='change-resolution-form',
    ),
    url(
        r'^(?P<pk>\d+)/comments/?$',
        views.InterviewCommentListCreateView.as_view(),
        name='comments',
    ),
    url(
        r'^(?P<pk>\d+)/add_problems_from_preset/?$',
        views.InterviewAddProblemsFromPreset.as_view(),
        name='add-problems-from-preset',
    ),
    url(
        r'^(?P<pk>\d+)/send_to_review/?$',
        views.InterviewSendToReviewView.as_view(),
        name='send-to-review',
    ),
    url(
        r'^(?P<pk>\d+)/send_to_review/_form/?$',
        views.InterviewSendToReviewView.as_form_view(),
        name='send-to-review-form',
    ),
    path(
        '<int:pk>/change_grade/',
        views.InterviewChangeGradeView.as_view(),
        name='change-grade',
    ),
    path(
        '<int:pk>/change_grade/_form/',
        views.InterviewChangeGradeView.as_form_view(),
        name='change-grade-form',
    ),
    path(
        '<int:pk>/choose_scale/',
        views.InterviewChooseScaleView.as_view(),
        name='choose-scale',
    ),
    path(
        '<int:pk>/choose_scale/_form/',
        views.InterviewChooseScaleView.as_form_view(),
        name='choose-scale-form',
    ),
]
