import waffle

import sform

from intranet.femida.src.publications.choices import JOBS_SUGGEST_TYPES


class SuggestRequestForm(sform.SForm):

    query = sform.CharField(state=sform.REQUIRED, min_length=3)
    suggest_type = sform.ChoiceField(choices=JOBS_SUGGEST_TYPES)
    limit = sform.IntegerField(default=10, min_value=1, max_value=50)

    def clean_suggest_type(self, suggest_type):
        if waffle.switch_is_active('enable_jobs_db_suggest'):
            default_suggest_type = JOBS_SUGGEST_TYPES.db_suggest
        else:
            default_suggest_type = JOBS_SUGGEST_TYPES.professions
        return suggest_type or default_suggest_type
