from rest_framework import status
from rest_framework.response import Response

from intranet.femida.src.api.core.permissions import StrictServicePermission
from intranet.femida.src.api.core.views import BaseView
from intranet.femida.src.api.jobs.suggest.forms import SuggestRequestForm
from intranet.femida.src.api.jobs.suggest.suggest import JobsSuggestRegistry


class JobsSuggestView(BaseView):

    permission_classes = [
        StrictServicePermission('permissions.can_view_external_publications'),
    ]

    validator_class = SuggestRequestForm

    def get(self, request, *args, **kwargs):
        form = self.get_validator_object(request.query_params)
        self.validate(form)
        params = form.cleaned_data
        data = {
            'results': JobsSuggestRegistry.get_suggest_data(**params),
        }
        return Response(data, status=status.HTTP_200_OK)
