from django_celery_monitoring.views import MonitoringCeleryView
from django.urls import path

from . import views


urlpatterns = [
    path(
        'celery/',
        MonitoringCeleryView.as_view(),
        name='celery',
    ),
    path(
        'celery_worker/',
        views.MonitoringCeleryWorkerView.as_view(),
        name='celery-worker',
    ),
    path(
        'db_consistency/',
        views.MonitoringDBConsistencyView.as_view(),
        name='db-consistency',
    ),
    path(
        'offer_consistency/',
        views.MonitoringOfferConsistencyView.as_view(),
        name='offer-consistency',
    ),
    path(
        'candidate_consistency/',
        views.MonitoringCandidateConsistencyView.as_view(),
        name='candidate-consistency',
    ),
    path(
        'celery_task_queue_size/',
        views.MonitoringCeleryTaskQueueSizeView.as_view(),
        name='celery-task-queue-size',
    ),
]
