from rest_framework import serializers


class PersonAddressDataSerializer(serializers.Serializer):

    code = serializers.CharField(source='kladr_code', default=None)
    zip = serializers.CharField(source='zip_code', default=None)
    house = serializers.CharField(source='building', default=None)
    bld = serializers.CharField(source='block', default=None)
    flat = serializers.CharField(source='apartment', default=None)
    str = serializers.CharField(source='address', default=None)


class PersonDataSerializer(serializers.Serializer):

    ticket = serializers.CharField(source='startrek_hr_key', default=None)

    login = serializers.CharField(source='username', default=None)
    lastName = serializers.CharField(source='passport_data.last_name', default=None)
    firstName = serializers.CharField(source='passport_data.first_name', default=None)
    middleNames = serializers.CharField(source='passport_data.middle_name', default=None)
    engName = serializers.SerializerMethodField()
    sex = serializers.CharField(source='passport_data.gender', default=None)
    birthday = serializers.CharField(source='passport_data.birthday', default=None)
    birthCountry = serializers.CharField(source='passport_data.birthCountry', default=None)
    birthRegion = serializers.CharField(source='passport_data.birthRegion', default=None)
    birthDistrict = serializers.CharField(source='passport_data.birthDistrict', default=None)
    birthCity = serializers.CharField(source='passport_data.birthCity', default=None)
    phoneNumber = serializers.CharField(source='profile.phone', default=None)
    citizenship = serializers.CharField(source='profile.citizenship', default=None)

    docType = serializers.SerializerMethodField()
    docSeries = serializers.CharField(source='passport_data.passport_series_number', default=None)
    docNumber = serializers.CharField(source='passport_data.passport_number', default=None)
    docIssuer = serializers.CharField(source='passport_data.issuer', default=None)
    docDate = serializers.CharField(source='passport_data.issue_date', default=None)
    docDepCode = serializers.CharField(source='passport_data.issuer_subdivision_code', default=None)
    regDate = serializers.CharField(source='passport_data.registration_date', default=None)

    personTaxId = serializers.SerializerMethodField()
    snils = serializers.CharField(source='snils_number', default=None)

    addrReg = PersonAddressDataSerializer(source='registration_address_data', default=None)
    addrRes = PersonAddressDataSerializer(source='residence_address_data', default=None)

    def get_engName(self, obj):
        return f'{obj.profile.last_name_en} {obj.profile.first_name_en}'

    def get_docType(self, obj):
        """
        Тип документа "Паспорт гражданина РФ" в терминах OEBS
        """
        return '21'

    def get_personTaxId(self, obj):
        verifications = obj.candidate.alive_verifications
        return verifications[0].inn if verifications else None
