from rest_framework import status
from rest_framework.response import Response

from intranet.femida.src.api.core.permissions import IsSuperuser
from intranet.femida.src.api.core.views import BaseView
from intranet.femida.src.oebs.api import get_budget_position


class BudgetPositionDetailView(BaseView):

    permission_classes = [IsSuperuser]

    def get(self, request, *args, **kwargs):
        """
        Бюджетная позиция из OEBS (заглушка)
        """
        budget_position_id = kwargs.get('pk')
        data = get_budget_position(budget_position_id)
        return Response(data, status=status.HTTP_200_OK)
