from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^$',
        views.OfferListView.as_view(),
        name='list',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        views.OfferDetailView.as_view(),
        name='detail',
    ),
    url(
        r'^(?P<pk>\d+)/_form/?$',
        views.OfferDetailView.as_form_view(),
        name='update-form',
    ),

    url(
        r'^(?P<pk>\d+)/generated_text/?$',
        views.OfferGeneratedTextView.as_view(),
        name='generated-text',
    ),

    # workflow

    url(
        r'^(?P<pk>\d+)/approve/?$',
        views.OfferApproveView.as_view(),
        name='approve',
    ),
    url(
        r'^(?P<pk>\d+)/approve/_form/?$',
        views.OfferApproveView.as_form_view(),
        name='approve-form',
    ),
    url(
        r'^(?P<pk>\d+)/reapprove/?$',
        views.OfferReapproveView.as_view(),
        name='reapprove',
    ),
    url(
        r'^(?P<pk>\d+)/send/?$',
        views.OfferSendView.as_view(),
        name='send',
    ),
    url(
        r'^(?P<pk>\d+)/send/_form/?$',
        views.OfferSendView.as_form_view(),
        name='send-form',
    ),
    url(
        r'^(?P<pk>\d+)/update_join_at/?$',
        views.OfferUpdateJoinAtView.as_view(),
        name='update-join-at',
    ),
    url(
        r'^(?P<pk>\d+)/update_join_at/_form/?$',
        views.OfferUpdateJoinAtView.as_form_view(),
        name='update-join-at-form',
    ),
    url(
        r'^(?P<pk>\d+)/update_username/?$',
        views.OfferUpdateUsernameView.as_view(),
        name='update-username',
    ),
    url(
        r'^(?P<pk>\d+)/update_username/_form/?$',
        views.OfferUpdateUsernameView.as_form_view(),
        name='update-username-form',
    ),
    url(
        r'^(?P<pk>\d+)/update_department/?$',
        views.OfferUpdateDepartmentView.as_view(),
        name='update-department',
    ),
    url(
        r'^(?P<pk>\d+)/update_department/_form/?$',
        views.OfferUpdateDepartmentView.as_form_view(),
        name='update-department-form',
    ),
    url(
        r'^(?P<pk>\d+)/delete/?$',
        views.OfferDeleteView.as_view(),
        name='delete',
    ),
    url(
        r'^(?P<pk>\d+)/delete/_form/?$',
        views.OfferDeleteView.as_form_view(),
        name='delete-form',
    ),
    url(
        r'^(?P<pk>\d+)/reject/?$',
        views.OfferRejectView.as_view(),
        name='reject',
    ),
    url(
        r'^(?P<pk>\d+)/reject/_form/?$',
        views.OfferRejectView.as_form_view(),
        name='reject-form',
    ),

    url(
        r'^(?P<pk>\d+)/check_login/?$',
        views.OfferCheckLoginView.as_view(),
        name='check-login',
    ),
]
