from rest_framework import serializers

from intranet.femida.src.api.core.serializers import FemidaSerializer
from intranet.femida.src.offers.choices import EMPLOYEE_TYPES
from intranet.femida.src.offers.controllers import LinkCtl
from intranet.femida.src.offers.models import Preprofile


class PreprofileSerializer(FemidaSerializer):

    url = serializers.SerializerMethodField()

    def get_url(self, obj):
        return LinkCtl(obj.link).url

    class Meta:
        model = Preprofile
        fields = (
            'id',
            'url',
        )


class PreprofileAcceptFormSerializer(serializers.Serializer):

    username = serializers.SerializerMethodField()
    join_at = serializers.DateField()

    def get_username(self, obj):
        return '' if obj['employee_type'] == EMPLOYEE_TYPES.new else obj['username']
