import sform

from intranet.femida.src.api.core.forms import UserSuggestField


class PresetForm(sform.SForm):

    name = sform.CharField(max_length=100, state=sform.REQUIRED)


class PresetFilterForm(sform.SForm):

    q = sform.CharField()
    created_by = UserSuggestField()

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        user = self.context.get('user')
        if user:
            self.fields['created_by'].default = user.username
